# R script for paper Milewicz, Hollway, Peacock, and Snidal
# Beyond Trade: The Expanding Scope of the Non-Trade Agenda in Trade Agreements
# Journal of Conflict Resolution

# Load the RSiena package
library(RSiena)

# Read the data
# setwd("~/Desktop/Replication Files/")
BilatPTA1989 <- as.matrix(read.csv("~/Desktop/NTI Replication/BilatPTA1989.csv", row.names = 1))
BilatPTA1994 <- as.matrix(read.csv("~/Desktop/NTI Replication/BilatPTA1994.csv", row.names = 1))
BilatPTA1999 <- as.matrix(read.csv("~/Desktop/NTI Replication/BilatPTA1999.csv", row.names = 1))
BilatPTA2004 <- as.matrix(read.csv("~/Desktop/NTI Replication/BilatPTA2004.csv", row.names = 1))
BilatPTA2009 <- as.matrix(read.csv("~/Desktop/NTI Replication/BilatPTA2009.csv", row.names = 1))
BilatNTI1989 <- as.matrix(read.csv("~/Desktop/NTI Replication/BilatNTI1989.csv", row.names = 1))
BilatNTI1994 <- as.matrix(read.csv("~/Desktop/NTI Replication/BilatNTI1994.csv", row.names = 1))
BilatNTI1999 <- as.matrix(read.csv("~/Desktop/NTI Replication/BilatNTI1999.csv", row.names = 1))
BilatNTI2004 <- as.matrix(read.csv("~/Desktop/NTI Replication/BilatNTI2004.csv", row.names = 1))
BilatNTI2009 <- as.matrix(read.csv("~/Desktop/NTI Replication/BilatNTI2009.csv", row.names = 1))
PluriPTA1989 <- as.matrix(read.csv("~/Desktop/NTI Replication/PluriPTA1989.csv", row.names = 1))
PluriPTA1994 <- as.matrix(read.csv("~/Desktop/NTI Replication/PluriPTA1994.csv", row.names = 1))
PluriPTA1999 <- as.matrix(read.csv("~/Desktop/NTI Replication/PluriPTA1999.csv", row.names = 1))
PluriPTA2004 <- as.matrix(read.csv("~/Desktop/NTI Replication/PluriPTA2004.csv", row.names = 1))
PluriPTA2009 <- as.matrix(read.csv("~/Desktop/NTI Replication/PluriPTA2009.csv", row.names = 1))
PluriNTI1989 <- as.matrix(read.csv("~/Desktop/NTI Replication/PluriNTI1989.csv", row.names = 1))
PluriNTI1994 <- as.matrix(read.csv("~/Desktop/NTI Replication/PluriNTI1994.csv", row.names = 1))
PluriNTI1999 <- as.matrix(read.csv("~/Desktop/NTI Replication/PluriNTI1999.csv", row.names = 1))
PluriNTI2004 <- as.matrix(read.csv("~/Desktop/NTI Replication/PluriNTI2004.csv", row.names = 1))
PluriNTI2009 <- as.matrix(read.csv("~/Desktop/NTI Replication/PluriNTI2009.csv", row.names = 1))

StateTrade <- as.matrix(read.csv("~/Desktop/NTI Replication/StateTrade.csv", row.names = 1))
StateGDP <- as.matrix(read.csv("~/Desktop/NTI Replication/StateGDP.csv", row.names = 1))
StateNTI <- as.matrix(read.csv("~/Desktop/NTI Replication/StateNTI.csv", row.names = 1))
StateTRI <- as.matrix(read.csv("~/Desktop/NTI Replication/StateTRI.csv", row.names = 1))
StateTUI <- as.matrix(read.csv("~/Desktop/NTI Replication/StateTUI.csv", row.names = 1))
StateDem <- as.matrix(read.csv("~/Desktop/NTI Replication/StateDem.csv", row.names = 1))
StateWTO <- as.matrix(read.csv("~/Desktop/NTI Replication/StateWTO.csv", row.names = 1))

BilatTrade1989 <- as.matrix(read.csv("~/Desktop/NTI Replication/BilatTrade1989.csv", row.names = 1))
BilatTrade1994 <- as.matrix(read.csv("~/Desktop/NTI Replication/BilatTrade1994.csv", row.names = 1))
BilatTrade1999 <- as.matrix(read.csv("~/Desktop/NTI Replication/BilatTrade1999.csv", row.names = 1))
BilatTrade2004 <- as.matrix(read.csv("~/Desktop/NTI Replication/BilatTrade2004.csv", row.names = 1))
PluriPTATrade1989 <- as.matrix(read.csv("~/Desktop/NTI Replication/PluriPTATrade1989.csv", row.names = 1))
PluriPTATrade1994 <- as.matrix(read.csv("~/Desktop/NTI Replication/PluriPTATrade1994.csv", row.names = 1))
PluriPTATrade1999 <- as.matrix(read.csv("~/Desktop/NTI Replication/PluriPTATrade1999.csv", row.names = 1))
PluriPTATrade2004 <- as.matrix(read.csv("~/Desktop/NTI Replication/PluriPTATrade2004.csv", row.names = 1))
PluriNTITrade1989 <- as.matrix(read.csv("~/Desktop/NTI Replication/PluriNTITrade1989.csv", row.names = 1))
PluriNTITrade1994 <- as.matrix(read.csv("~/Desktop/NTI Replication/PluriNTITrade1994.csv", row.names = 1))
PluriNTITrade1999 <- as.matrix(read.csv("~/Desktop/NTI Replication/PluriNTITrade1999.csv", row.names = 1))
PluriNTITrade2004 <- as.matrix(read.csv("~/Desktop/NTI Replication/PluriNTITrade2004.csv", row.names = 1))

# Replication of figure 3 (EU and US bilateral ego networks)
library(igraph)
Bilat1989 <- graph.adjacency(BilatPTA1989, mode = "undirected") %>% set_edge_attr("type", value="PTA") + 
  graph.adjacency(BilatNTI1989, mode = "undirected")
EU.1989 <- graph.neighborhood(Bilat1989, 1, nodes=V(net)$name=="EUU", mode="all")[[1]]
US.1989 <- graph.neighborhood(Bilat1989, 1, nodes=V(net)$name=="USA", mode="all")[[1]]
Bilat1994 <- graph.adjacency(BilatPTA1994, mode = "undirected") %>% set_edge_attr("type", value="PTA") + 
  graph.adjacency(BilatNTI1994, mode = "undirected")
EU.1994 <- graph.neighborhood(Bilat1994, 1, nodes=V(net)$name=="EUU", mode="all")[[1]]
US.1994 <- graph.neighborhood(Bilat1994, 1, nodes=V(net)$name=="USA", mode="all")[[1]]
Bilat1999 <- graph.adjacency(BilatPTA1999, mode = "undirected") %>% set_edge_attr("type", value="PTA") + 
  graph.adjacency(BilatNTI1999, mode = "undirected")
EU.1999 <- graph.neighborhood(Bilat1999, 1, nodes=V(net)$name=="EUU", mode="all")[[1]]
US.1999 <- graph.neighborhood(Bilat1999, 1, nodes=V(net)$name=="USA", mode="all")[[1]]
Bilat2004 <- graph.adjacency(BilatPTA2004, mode = "undirected") %>% set_edge_attr("type", value="PTA") + 
  graph.adjacency(BilatNTI2004, mode = "undirected")
EU.2004 <- graph.neighborhood(Bilat2004, 1, nodes=V(net)$name=="EUU", mode="all")[[1]]
US.2004 <- graph.neighborhood(Bilat2004, 1, nodes=V(net)$name=="USA", mode="all")[[1]]
Bilat2009 <- graph.adjacency(BilatPTA2009, mode = "undirected") %>% set_edge_attr("type", value="PTA") + 
  graph.adjacency(BilatNTI2009, mode = "undirected")
EU.2009 <- graph.neighborhood(Bilat2009, 1, nodes=V(net)$name=="EUU", mode="all")[[1]]
US.2009 <- graph.neighborhood(Bilat2009, 1, nodes=V(net)$name=="USA", mode="all")[[1]]

par(mfrow=c(2,5), mar=c(2,0,2,0))
plot(EU.1989, vertex.size=5, vertex.color="white", vertex.frame.color=NA, edge.lty=ifelse(is.na(E(EU.1989)$type), 1, 2),
     main="EU 1989")
mtext(paste(paste("EU's Bilateral Partners =", length(V(EU.1989))-1),
      paste("Transitivity =", round(transitivity(EU.1989),2)), sep = "\n"), side=1, cex=0.6)
plot(EU.1994, vertex.size=5, vertex.color="white", vertex.frame.color=NA, edge.lty=ifelse(is.na(E(EU.1994)$type), 1, 2),
     main="EU 1994")
mtext(paste(paste("EU's Bilateral Partners =", length(V(EU.1994))-1),
            paste("Transitivity =", round(transitivity(EU.1994),2)), sep = "\n"), side=1, cex=0.6)
plot(EU.1999, vertex.size=5, vertex.color="white", vertex.frame.color=NA, edge.lty=ifelse(is.na(E(EU.1999)$type), 1, 2),
     main="EU 1999")
mtext(paste(paste("EU's Bilateral Partners =", length(V(EU.1999))-1),
            paste("Transitivity =", round(transitivity(EU.1999),2)), sep = "\n"), side=1, cex=0.6)
plot(EU.2004, vertex.size=5, vertex.color="white", vertex.frame.color=NA, edge.lty=ifelse(is.na(E(EU.2004)$type), 1, 2),
     main="EU 2004")
mtext(paste(paste("EU's Bilateral Partners =", length(V(EU.2004))-1),
            paste("Transitivity =", round(transitivity(EU.2004),2)), sep = "\n"), side=1, cex=0.6)
plot(EU.2009, vertex.size=5, vertex.color="white", vertex.frame.color=NA, edge.lty=ifelse(is.na(E(EU.2009)$type), 1, 2),
     main="EU 2009")
mtext(paste(paste("EU's Bilateral Partners =", length(V(EU.2009))-1),
            paste("Transitivity =", round(transitivity(EU.2009),2)), sep = "\n"), side=1, cex=0.6)
plot(US.1989, vertex.size=5, vertex.color="white", vertex.frame.color=NA, edge.lty=ifelse(is.na(E(US.1989)$type), 1, 2),
     main="US 1989")
mtext(paste(paste("US's Bilateral Partners =", length(V(US.1989))-1),
            paste("Transitivity =", round(transitivity(US.1989),2)), sep = "\n"), side=1, cex=0.6)
plot(US.1994, vertex.size=5, vertex.color="white", vertex.frame.color=NA, edge.lty=ifelse(is.na(E(US.1994)$type), 1, 2),
     main="US 1994")
mtext(paste(paste("US's Bilateral Partners =", length(V(US.1994))-1),
            paste("Transitivity =", round(transitivity(US.1994),2)), sep = "\n"), side=1, cex=0.6)
plot(US.1999, vertex.size=5, vertex.color="white", vertex.frame.color=NA, edge.lty=ifelse(is.na(E(US.1999)$type), 1, 2),
     main="US 1999")
mtext(paste(paste("US's Bilateral Partners =", length(V(US.1999))-1),
            paste("Transitivity =", round(transitivity(US.1999),2)), sep = "\n"), side=1, cex=0.6)
plot(US.2004, vertex.size=5, vertex.color="white", vertex.frame.color=NA, edge.lty=ifelse(is.na(E(US.2004)$type), 1, 2),
     main="US 2004")
mtext(paste(paste("US's Bilateral Partners =", length(V(US.2004))-1),
            paste("Transitivity =", round(transitivity(US.2004),2)), sep = "\n"), side=1, cex=0.6)
plot(US.2009, vertex.size=5, vertex.color="white", vertex.frame.color=NA, edge.lty=ifelse(is.na(E(US.2009)$type), 1, 2),
     main="US 2009")
mtext(paste(paste("US's Bilateral Partners =", length(V(US.2009))-1),
            paste("Transitivity =", round(transitivity(US.2009),2)), sep = "\n"), side=1, cex=0.6)

# Replication of figure 4 (Four interdependent networks)
par(mfrow=c(2,2), mar=c(1.1,1.1,1.1,1.1))
plot(delete.vertices(graph.adjacency(BilatPTA2009, mode = "undirected"), 
                     degree(graph.adjacency(BilatPTA2009, mode = "undirected"))==0), 
     vertex.size=5, vertex.color="white", vertex.frame.color=NA, vertex.label.cex=0.6, main="BilatPTA")
plot(delete.vertices(graph.adjacency(BilatNTI2009, mode = "undirected"),
                     degree(graph.adjacency(BilatNTI2009, mode = "undirected"))==0), 
     vertex.size=5, vertex.color="white", vertex.frame.color=NA, vertex.label.cex=0.6, main="BilatNTI")
plot(delete.vertices(graph.incidence(PluriPTA2009, directed=F),
                     degree(graph.incidence(PluriPTA2009, directed=F))==0), 
     vertex.size=5, vertex.color="white", vertex.frame.color=NA, vertex.label.cex=0.6, main="PluriPTA")
plot(delete.vertices(graph.incidence(PluriNTI2009, directed=F),
                     degree(graph.incidence(PluriNTI2009, directed=F))==0), 
     vertex.size=5, vertex.color="white", vertex.frame.color=NA, vertex.label.cex=0.6, main="PluriNTI")

#Define the nodesets
countries <- sienaNodeSet(nrow(BilatPTA1989), nodeSetName="countries")
pluriptas <- sienaNodeSet(ncol(PluriPTA1989), nodeSetName="pluriptas")
plurintis <- sienaNodeSet(ncol(PluriNTI1989), nodeSetName="plurintis")

# Create the dependent networks
BilatPTA <- sienaDependent(array(c(BilatPTA1989, BilatPTA1994, BilatPTA1999, BilatPTA2004, BilatPTA2009),
                                 dim=c(nrow(BilatPTA1989), ncol(BilatPTA1989), 5)),
                           type="oneMode", nodeSet="countries", allowOnly=F, sparse=F)

BilatNTI <- sienaDependent(array(c(BilatNTI1989, BilatNTI1994, BilatNTI1999, BilatNTI2004, BilatNTI2009),
                                 dim=c(nrow(BilatNTI1989), ncol(BilatNTI1989), 5)),
                           type="oneMode", nodeSet="countries", allowOnly=F, sparse=F)

PluriPTA <- sienaDependent(array(c(PluriPTA1989, PluriPTA1994, PluriPTA1999, PluriPTA2004, PluriPTA2009),
                                 dim=c(nrow(PluriPTA1989), ncol(PluriPTA1989), 5)), 
                           type="bipartite", nodeSet=c("countries", "pluriptas"), allowOnly=F, sparse=F)

PluriNTI <- sienaDependent(array(c(PluriNTI1989, PluriNTI1994, PluriNTI1999, PluriNTI2004, PluriNTI2009),
                                 dim=c(nrow(PluriNTI1989), ncol(PluriNTI1989), 5)), 
                           type="bipartite", nodeSet=c("countries", "plurintis"), allowOnly=F, sparse=F)

# Create the independent variables
StateWTO <- varCovar(as.matrix(StateWTO), nodeSet="countries", centered=F)
StateTrade <- varCovar(as.matrix(StateTrade), nodeSet="countries")
StateGDP <- varCovar(as.matrix(StateGDP), nodeSet="countries")
StateNTI <- varCovar(as.matrix(StateNTI), nodeSet="countries")
StateTRI <- varCovar(as.matrix(StateTRI), nodeSet="countries")
StateTUI <- varCovar(as.matrix(StateTUI), nodeSet="countries")
StateDem <- varCovar(as.matrix(StateDem), nodeSet="countries")

BilatTrade <- varDyadCovar(array(c(BilatTrade1989, BilatTrade1989, BilatTrade1989, BilatTrade1989),
                   dim=c(nrow(BilatTrade1989),ncol(BilatTrade1989),4)), nodeSet="countries", sparse=F)
PluriPTATrade <- varDyadCovar(array(c(PluriPTATrade1989, PluriPTATrade1989, PluriPTATrade1989, PluriPTATrade1989),
                                 dim=c(nrow(PluriPTATrade1989),ncol(PluriPTATrade1989),4)), 
                              type="bipartite", nodeSet=c("countries", "pluriptas"), sparse=F)
PluriNTITrade <- varDyadCovar(array(c(PluriNTITrade1989, PluriNTITrade1989, PluriNTITrade1989, PluriNTITrade1989),
                                 dim=c(nrow(PluriNTITrade1989),ncol(PluriNTITrade1989),4)), 
                              type="bipartite", nodeSet=c("countries", "plurintis"), sparse=F)

cc <- sienaCompositionChangeFromFile("/Users/james/Desktop/NTI Replication/cc.csv", nodeSet="countries")

# Define the data
ntiData <- sienaDataCreate(BilatPTA, BilatNTI, PluriPTA, PluriNTI, # Dependent networks
                           StateWTO, BilatTrade, PluriPTATrade, PluriNTITrade, # Trade controls
                           StateTrade, StateGDP, # Power-related covariates
                           StateNTI, StateTRI, StateTUI, StateDem, # Commitment-related covariates
                           compositionChange = cc, # Composition change
                           nodeSets=list(countries, pluriptas, plurintis)) # Nodesets

# Export report on data and for the results
print01Report(ntiData, modelname = 'ntiReplication')

# Create new effects structure
ntiEffects <- getEffects(ntiData)

# Specify the model
# BilatPTA ####
# Controls
ntiEffects <- includeEffects(ntiEffects, name="BilatPTA", X, interaction1="BilatTrade")
ntiEffects <- includeEffects(ntiEffects, name="BilatPTA", egoX, interaction1="StateWTO")
# Power
ntiEffects <- includeEffects(ntiEffects, name="BilatPTA", egoX, interaction1="StateTrade")
ntiEffects <- includeEffects(ntiEffects, name="BilatPTA", simX, interaction1="StateTrade")
# Commitment
ntiEffects <- includeEffects(ntiEffects, name="BilatPTA", egoX, interaction1="StateNTI")
ntiEffects <- includeEffects(ntiEffects, name="BilatPTA", egoXaltX, interaction1="StateNTI")
# Cost
ntiEffects <- includeEffects(ntiEffects, name="BilatPTA", inPopSqrt, outTrunc)
# Cross-network effects
ntiEffects <- includeEffects(ntiEffects, name="BilatPTA", inPopIntn, interaction1="BilatNTI")
ntiEffects <- includeEffects(ntiEffects, name="BilatPTA", outActIntn, interaction1="PluriPTA")
ntiEffects <- includeEffects(ntiEffects, name="BilatPTA", outActIntn, interaction1="PluriNTI")

# BilatNTI ####
# Controls
ntiEffects <- includeEffects(ntiEffects, name="BilatNTI", X, interaction1="BilatTrade")
ntiEffects <- includeEffects(ntiEffects, name="BilatNTI", egoX, interaction1="StateWTO")
# Power
ntiEffects <- includeEffects(ntiEffects, name="BilatNTI", egoX, interaction1="StateTrade")
ntiEffects <- includeEffects(ntiEffects, name="BilatNTI", simX, interaction1="StateTrade")
# Commitment
ntiEffects <- includeEffects(ntiEffects, name="BilatNTI", egoX, interaction1="StateNTI")
ntiEffects <- includeEffects(ntiEffects, name="BilatNTI", egoXaltX, interaction1="StateNTI")
# Cost
ntiEffects <- includeEffects(ntiEffects, name="BilatNTI", inPopSqrt, outTrunc)
# Cross-network effects
ntiEffects <- includeEffects(ntiEffects, name="BilatNTI", inPopIntn, interaction1="BilatPTA")
ntiEffects <- includeEffects(ntiEffects, name="BilatNTI", outActIntn, interaction1="PluriPTA")
ntiEffects <- includeEffects(ntiEffects, name="BilatNTI", outActIntn, interaction1="PluriNTI")

# PluriPTA ####
ntiEffects <- includeEffects(ntiEffects, name="PluriPTA", X, interaction1="PluriPTATrade")
ntiEffects <- includeEffects(ntiEffects, name="PluriPTA", egoX, interaction1="StateWTO")
# Power
ntiEffects <- includeEffects(ntiEffects, name="PluriPTA", egoX, interaction1="StateTrade")
ntiEffects <- includeEffects(ntiEffects, name="PluriPTA", totInDist2, interaction1="StateTrade")
# Commitment
ntiEffects <- includeEffects(ntiEffects, name="PluriPTA", egoX, interaction1="StateNTI")
ntiEffects <- includeInteraction(ntiEffects, name="PluriPTA", egoX, altInDist2, interaction1=c("StateNTI", "StateNTI"))
# Cost
ntiEffects <- includeEffects(ntiEffects, name="PluriPTA", outActSqrt, cycle4, inPopSqrt, outTrunc, in3Plus)
# Cross-network effects
ntiEffects <- includeEffects(ntiEffects, name="PluriPTA", outActIntn, interaction1="BilatPTA")
ntiEffects <- includeEffects(ntiEffects, name="PluriPTA", outActIntn, interaction1="BilatNTI")
ntiEffects <- includeEffects(ntiEffects, name="PluriPTA", outActIntn, interaction1="PluriNTI")

#PluriNTI ####
# Controls
ntiEffects <- includeEffects(ntiEffects, name="PluriNTI", X, interaction1="PluriNTITrade")
ntiEffects <- includeEffects(ntiEffects, name="PluriNTI", egoX, interaction1="StateWTO")
# Power
ntiEffects <- includeEffects(ntiEffects, name="PluriNTI", egoX, interaction1="StateTrade")
ntiEffects <- includeEffects(ntiEffects, name="PluriNTI", totInDist2, interaction1="StateTrade")
# Commitment
ntiEffects <- includeEffects(ntiEffects, name="PluriNTI", egoX, interaction1="StateNTI")
ntiEffects <- includeInteraction(ntiEffects, name="PluriNTI", egoX, altInDist2, interaction1=c("StateNTI", "StateNTI"))
# Cost
ntiEffects <- includeEffects(ntiEffects, name="PluriNTI", outActSqrt, cycle4, inPopSqrt, outTrunc, in3Plus)
# Cross-network effects
ntiEffects <- includeEffects(ntiEffects, name="PluriNTI", outActIntn, interaction1="BilatPTA")
ntiEffects <- includeEffects(ntiEffects, name="PluriNTI", outActIntn, interaction1="BilatNTI")
ntiEffects <- includeEffects(ntiEffects, name="PluriNTI", outActIntn, interaction1="PluriPTA")

# Check the current model specification
ntiEffects

# Define the kind of non-directed model
ntiAlg <- sienaAlgorithmCreate(useStdInits=FALSE, projname='ntiReplication', modelType=3)

# Estimate
ntiResults <- siena07(ntiAlg, data = ntiData, effects = ntiEffects)
ntiResults 

# Additional effects used in robustness checks ####

# Trade Interaction as Power (table 8)
# Rerun lines 190-257, then the following lines, before rerunning line 263
ntiEffects <- includeEffects(ntiEffects, name="BilatPTA", simX, interaction1="StateTrade", include = F)
ntiEffects <- includeEffects(ntiEffects, name="BilatNTI", simX, interaction1="StateTrade", include = F)
ntiEffects <- includeEffects(ntiEffects, name="PluriPTA", totInDist2, interaction1="StateTrade", include = F)
ntiEffects <- includeEffects(ntiEffects, name="PluriNTI", totInDist2, interaction1="StateTrade", include = F)
ntiEffects <- includeInteraction(ntiEffects, name="BilatPTA", egoX, altX, interaction1=c("StateTrade", "StateTrade"))
ntiEffects <- includeInteraction(ntiEffects, name="BilatNTI", egoX, altX, interaction1=c("StateTrade", "StateTrade"))
ntiEffects <- includeInteraction(ntiEffects, name="PluriPTA", egoX, totInDist2, interaction1=c("StateTrade", "StateTrade"))
ntiEffects <- includeInteraction(ntiEffects, name="PluriNTI", egoX, totInDist2, interaction1=c("StateTrade", "StateTrade"))

# GDP as Power (table 5)
# Rerun lines 190-257, then the following lines, before rerunning line 263
ntiEffects <- includeEffects(ntiEffects, name="BilatPTA", egoX, interaction1="StateTrade", include = F)
ntiEffects <- includeEffects(ntiEffects, name="BilatPTA", simX, interaction1="StateTrade", include = F)
ntiEffects <- includeEffects(ntiEffects, name="BilatNTI", egoX, interaction1="StateTrade", include = F)
ntiEffects <- includeEffects(ntiEffects, name="BilatNTI", simX, interaction1="StateTrade", include = F)
ntiEffects <- includeEffects(ntiEffects, name="PluriPTA", egoX, interaction1="StateTrade", include = F)
ntiEffects <- includeEffects(ntiEffects, name="PluriPTA", totInDist2, interaction1="StateTrade", include = F)
ntiEffects <- includeEffects(ntiEffects, name="PluriNTI", egoX, interaction1="StateTrade", include = F)
ntiEffects <- includeEffects(ntiEffects, name="PluriNTI", totInDist2, interaction1="StateTrade", include = F)
ntiEffects <- includeEffects(ntiEffects, name="BilatPTA", egoX, interaction1="StateGDP")
ntiEffects <- includeInteraction(ntiEffects, name="BilatPTA", egoX, altX, interaction1=c("StateGDP", "StateGDP"))
ntiEffects <- includeEffects(ntiEffects, name="BilatNTI", egoX, interaction1="StateGDP")
ntiEffects <- includeInteraction(ntiEffects, name="BilatNTI", egoX, altX, interaction1=c("StateGDP", "StateGDP"))
ntiEffects <- includeEffects(ntiEffects, name="PluriPTA", egoX, interaction1="StateGDP")
ntiEffects <- includeInteraction(ntiEffects, name="PluriPTA", egoX, totInDist2, interaction1=c("StateGDP", "StateGDP"))
ntiEffects <- includeEffects(ntiEffects, name="PluriNTI", egoX, interaction1="StateGDP")
ntiEffects <- includeInteraction(ntiEffects, name="PluriNTI", egoX, totInDist2, interaction1=c("StateGDP", "StateGDP"))

# Democracy as Commitment (table 6)
# Rerun lines 190-257, then the following lines, before rerunning line 263
ntiEffects <- includeEffects(ntiEffects, name="BilatPTA", egoX, interaction1="StateNTI", include = F)
ntiEffects <- includeEffects(ntiEffects, name="BilatPTA", egoXaltX, interaction1="StateNTI", include = F)
ntiEffects <- includeEffects(ntiEffects, name="BilatNTI", egoX, interaction1="StateNTI", include = F)
ntiEffects <- includeEffects(ntiEffects, name="BilatNTI", egoXaltX, interaction1="StateNTI", include = F)
ntiEffects <- includeEffects(ntiEffects, name="PluriPTA", egoX, interaction1="StateNTI", include = F)
ntiEffects <- includeEffects(ntiEffects, name="PluriPTA", altInDist2, interaction1="StateNTI", include = F)
ntiEffects <- includeEffects(ntiEffects, name="PluriNTI", egoX, interaction1="StateNTI", include = F)
ntiEffects <- includeEffects(ntiEffects, name="PluriNTI", altInDist2, interaction1="StateNTI", include = F)
ntiEffects <- includeEffects(ntiEffects, name="BilatPTA", egoX, interaction1="StateDem")
ntiEffects <- includeInteraction(ntiEffects, name="BilatPTA", egoX, altX, interaction1=c("StateDem", "StateDem"))
ntiEffects <- includeEffects(ntiEffects, name="BilatNTI", egoX, interaction1="StateDem")
ntiEffects <- includeInteraction(ntiEffects, name="BilatNTI", egoX, altX, interaction1=c("StateDem", "StateDem"))
ntiEffects <- includeEffects(ntiEffects, name="PluriPTA", egoX, interaction1="StateDem")
ntiEffects <- includeInteraction(ntiEffects, name="PluriPTA", egoX, altInDist2, interaction1=c("StateDem", "StateDem"))
ntiEffects <- includeEffects(ntiEffects, name="PluriNTI", egoX, interaction1="StateDem")
ntiEffects <- includeInteraction(ntiEffects, name="PluriNTI", egoX, altInDist2, interaction1=c("StateDem", "StateDem"))

# Issue-type treaties as Commitment (table 7)
# Rerun lines 190-257, then the following lines, before rerunning line 263
ntiEffects <- includeEffects(ntiEffects, name="BilatPTA", egoX, interaction1="StateNTI", include = F)
ntiEffects <- includeEffects(ntiEffects, name="BilatPTA", egoXaltX, interaction1="StateNTI", include = F)
ntiEffects <- includeEffects(ntiEffects, name="BilatNTI", egoX, interaction1="StateNTI", include = F)
ntiEffects <- includeEffects(ntiEffects, name="BilatNTI", egoXaltX, interaction1="StateNTI", include = F)
ntiEffects <- includeEffects(ntiEffects, name="PluriPTA", egoX, interaction1="StateNTI", include = F)
ntiEffects <- includeEffects(ntiEffects, name="PluriPTA", altInDist2, interaction1="StateNTI", include = F)
ntiEffects <- includeEffects(ntiEffects, name="PluriNTI", egoX, interaction1="StateNTI", include = F)
ntiEffects <- includeEffects(ntiEffects, name="PluriNTI", altInDist2, interaction1="StateNTI", include = F)
ntiEffects <- includeEffects(ntiEffects, name="BilatPTA", egoX, interaction1="StateTRI")
ntiEffects <- includeInteraction(ntiEffects, name="BilatPTA", egoX, altX, interaction1=c("StateTRI", "StateTRI"))
ntiEffects <- includeEffects(ntiEffects, name="BilatPTA", egoX, interaction1="StateTUI")
ntiEffects <- includeInteraction(ntiEffects, name="BilatPTA", egoX, altX, interaction1=c("StateTUI", "StateTUI"))
ntiEffects <- includeEffects(ntiEffects, name="BilatNTI", egoX, interaction1="StateTRI")
ntiEffects <- includeInteraction(ntiEffects, name="BilatNTI", egoX, altX, interaction1=c("StateTRI", "StateTRI"))
ntiEffects <- includeEffects(ntiEffects, name="BilatNTI", egoX, interaction1="StateTUI")
ntiEffects <- includeInteraction(ntiEffects, name="BilatNTI", egoX, altX, interaction1=c("StateTUI", "StateTUI"))
ntiEffects <- includeEffects(ntiEffects, name="PluriPTA", egoX, interaction1="StateTRI")
ntiEffects <- includeInteraction(ntiEffects, name="PluriPTA", egoX, altInDist2, interaction1=c("StateTRI", "StateTRI"))
ntiEffects <- includeEffects(ntiEffects, name="PluriPTA", egoX, interaction1="StateTUI")
ntiEffects <- includeInteraction(ntiEffects, name="PluriPTA", egoX, altInDist2, interaction1=c("StateTUI", "StateTUI"))
ntiEffects <- includeEffects(ntiEffects, name="PluriNTI", egoX, interaction1="StateTRI")
ntiEffects <- includeInteraction(ntiEffects, name="PluriNTI", egoX, altInDist2, interaction1=c("StateTRI", "StateTRI"))
ntiEffects <- includeEffects(ntiEffects, name="PluriNTI", egoX, interaction1="StateTUI")
ntiEffects <- includeInteraction(ntiEffects, name="PluriNTI", egoX, altInDist2, interaction1=c("StateTUI", "StateTUI"))

# With closure cross network effects (table 9)
# Rerun lines 190-257, then the following lines, before rerunning line 263
ntiEffects <- includeEffects(ntiEffects, name="BilatPTA", inPopIntn, interaction1="BilatNTI", include = F)
ntiEffects <- includeEffects(ntiEffects, name="BilatPTA", outActIntn, interaction1="PluriPTA", include = F)
ntiEffects <- includeEffects(ntiEffects, name="BilatPTA", outActIntn, interaction1="PluriNTI", include = F)
ntiEffects <- includeEffects(ntiEffects, name="BilatNTI", inPopIntn, interaction1="BilatPTA", include = F)
ntiEffects <- includeEffects(ntiEffects, name="BilatNTI", outActIntn, interaction1="PluriPTA", include = F)
ntiEffects <- includeEffects(ntiEffects, name="BilatNTI", outActIntn, interaction1="PluriNTI", include = F)
ntiEffects <- includeEffects(ntiEffects, name="PluriPTA", outActIntn, interaction1="BilatPTA", include = F)
ntiEffects <- includeEffects(ntiEffects, name="PluriPTA", outActIntn, interaction1="BilatNTI", include = F)
ntiEffects <- includeEffects(ntiEffects, name="PluriPTA", outActIntn, interaction1="PluriNTI", include = F)
ntiEffects <- includeEffects(ntiEffects, name="PluriNTI", outActIntn, interaction1="BilatPTA", include = F)
ntiEffects <- includeEffects(ntiEffects, name="PluriNTI", outActIntn, interaction1="BilatNTI", include = F)
ntiEffects <- includeEffects(ntiEffects, name="PluriNTI", outActIntn, interaction1="PluriPTA", include = F)
ntiEffects <- includeEffects(ntiEffects, name="BilatPTA", crprod, interaction1="BilatNTI")
ntiEffects <- includeEffects(ntiEffects, name="BilatPTA", from, interaction1="PluriPTA")
ntiEffects <- includeEffects(ntiEffects, name="BilatPTA", from, interaction1="PluriNTI")
ntiEffects <- includeEffects(ntiEffects, name="BilatNTI", crprod, interaction1="BilatPTA")
ntiEffects <- includeEffects(ntiEffects, name="BilatNTI", from, interaction1="PluriPTA")
ntiEffects <- includeEffects(ntiEffects, name="BilatNTI", from, interaction1="PluriNTI")
ntiEffects <- includeEffects(ntiEffects, name="PluriPTA", to, interaction1="BilatPTA")
ntiEffects <- includeEffects(ntiEffects, name="PluriPTA", to, interaction1="BilatNTI")
ntiEffects <- includeEffects(ntiEffects, name="PluriPTA", sharedTo, interaction1="PluriNTI")
ntiEffects <- includeEffects(ntiEffects, name="PluriNTI", to, interaction1="BilatPTA")
ntiEffects <- includeEffects(ntiEffects, name="PluriNTI", to, interaction1="BilatNTI")
ntiEffects <- includeEffects(ntiEffects, name="PluriNTI", sharedTo, interaction1="PluriPTA")

# With closure cross network effects without ego power or commitment (table 10)
# Rerun lines 190-257, then lines 346-369, then the following lines, before rerunning line 263
ntiEffects <- includeEffects(ntiEffects, name="BilatPTA", egoX, interaction1="StateTrade", include = F)
ntiEffects <- includeEffects(ntiEffects, name="BilatPTA", egoX, interaction1="StateNTI", include = F)
ntiEffects <- includeEffects(ntiEffects, name="BilatNTI", egoX, interaction1="StateTrade", include = F)
ntiEffects <- includeEffects(ntiEffects, name="BilatNTI", egoX, interaction1="StateNTI", include = F)
ntiEffects <- includeEffects(ntiEffects, name="PluriPTA", egoX, interaction1="StateTrade", include = F)
ntiEffects <- includeEffects(ntiEffects, name="PluriPTA", egoX, interaction1="StateNTI", include = F)
ntiEffects <- includeEffects(ntiEffects, name="PluriNTI", egoX, interaction1="StateTrade", include = F)
ntiEffects <- includeEffects(ntiEffects, name="PluriNTI", egoX, interaction1="StateNTI", include = F)

# Without ego power and commitment (table 11)
# Rerun lines 190-257, then lines 373-380, before rerunning line 263